int g_sas : SasGlobal
<
    int3 SasVersion = {1, 0, 0};
>;

const float SHADOW_EPSILON 	= 0.00005f;
const float SMAP_SIZE 		= 1024.0f;

float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4x4 g_light_view_projection_matrix;
float4	g_camera_eye_vector;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
float3 	g_EyePosW;
float3 	g_LightPosW;
float3	g_LightDirW;
float 	g_OffsetValue;
texture g_tex0;
texture g_shadowtex;
float g_Spectrum;
float g_delta_time;
float g_random;

sampler TexS = sampler_state
{
	Texture = <g_tex0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	AddressU  = WRAP; 
    	AddressV  = WRAP;
};


sampler ShadowMapS = sampler_state
{
	Texture = <g_shadowtex>;
	MinFilter = ANISOTROPIC;
	MagFilter = ANISOTROPIC;
	MipFilter = ANISOTROPIC;
	AddressU  = CLAMP; 
   	 AddressV  = CLAMP;
};


void SpecularVS(float3 posL         : POSITION0,
                   float3 normalL      : NORMAL0,
                   float2 tex0         : TEXCOORD0,
                   out float4 oPosH    : POSITION0,
                   out float3 oPosW    : TEXCOORD0,
                   out float3 oNormalW : TEXCOORD1,
                   out float3 oToEyeW  : TEXCOORD2,
                   out float2 oTex0    : TEXCOORD3,
                   out float4 oProjTex : TEXCOORD4)
{
	// Transform to homogeneous clip space.
	oPosH = mul(float4(posL, 1.0f), g_world_matrix);
	oPosH = mul( oPosH, g_view_projection_matrix );
	
	// Transform vertex position to world space.
	oPosW = mul(float4(posL, 1.0f), g_world_matrix).xyz;
	
	// Transform normal to world space (assume no non-uniform scaling).
	oNormalW = mul(float4(normalL, 0.0f), g_world_matrix).xyz;
	
	// Compute the unit vector from the vertex to the eye.
	oToEyeW = g_EyePosW - oPosW;
	
	
	// Pass on texture coords to PS
	oTex0 = tex0;
	//oTex0.y += sin( g_delta_time * g_Spectrum );
	//oTex0.x += cos( g_delta_time * g_Spectrum );

	// Generate projective texture coordinates.
	oProjTex = mul(float4(posL, 1.0f), g_light_view_projection_matrix);
}

float4 SpecularPS(float3 posW    : TEXCOORD0,
                     float3 normalW : TEXCOORD1,
                     float3 toEyeW  : TEXCOORD2,
                     float2 tex0    : TEXCOORD3,
                     float4 projTex : TEXCOORD4) : COLOR
{

	// Interpolated normals can become unnormal--so normalize.
	normalW = normalize(normalW);
	toEyeW  = normalize(toEyeW);
	
	// Light vector is from pixel to spotlight position.
	float3 lightVecW = normalize(g_LightPosW - posW);
	
	// Compute the reflection vector.
	float3 r = reflect(-lightVecW, normalW);
	
	// Determine how much (if any) specular light makes it into the eye.
	float t  = pow(max(dot(r, toEyeW), 0.0f), 8.0f);
	
	// Determine the diffuse light intensity that strikes the vertex.
	float s = max(dot(lightVecW, normalW), 0.0f);
	
	// Compute the ambient, diffuse and specular terms separately. 
	float3 spec = float3(0.2f, 0.2f, 0.2);//t*(gMtrl.spec*gLight.spec).rgb;
	float3 diffuse = float3(0.2f, 0.2f, 0.2);//s*(gMtrl.diffuse*gLight.diffuse.rgb);
	float3 ambient = float3(0.2f, 0.2f, 0.2);//gMtrl.ambient*gLight.ambient;
	
	// Compute spotlight coefficient.
	float spot = pow(max( dot(-lightVecW, g_LightDirW), 0.0f), 8.0f);
	
	// Sample decal map.
	
	float4 texColor = tex2D(TexS, tex0); 

	//texColor += tex2D( TexS, tex0.xy + g_random * 0.01f);
	//texColor += tex2D( TexS, tex0.xy + g_random * 0.02f);
	//texColor += tex2D( TexS, tex0.xy + g_random * 0.03f);

	//texColor = texColor / 4;

	// Project the texture coords and scale/offset to [0, 1].
	projTex.xy /= projTex.w;            
	projTex.x =  0.5f*projTex.x + 0.5f; 
	projTex.y = -0.5f*projTex.y + 0.5f;
	
	// Compute pixel depth for shadowing.
	float depth = projTex.z / projTex.w;
 
	// Transform to texel space
    float2 texelpos = SMAP_SIZE * projTex.xy;
        
    // Determine the lerp amounts.           
    float2 lerps = frac( texelpos );
    
    // 2x2 percentage closest filter.
    float dx = 1.0f / SMAP_SIZE;
	float s0 = (tex2D(ShadowMapS, projTex.xy).r + SHADOW_EPSILON < depth) ? 0.0f : 1.0f;
	float s1 = (tex2D(ShadowMapS, projTex.xy + float2(dx, 0.0f)).r + SHADOW_EPSILON < depth) ? 0.0f : 1.0f;
	float s2 = (tex2D(ShadowMapS, projTex.xy + float2(0.0f, dx)).r + SHADOW_EPSILON < depth) ? 0.0f : 1.0f;
	float s3 = (tex2D(ShadowMapS, projTex.xy + float2(dx, dx)).r   + SHADOW_EPSILON < depth) ? 0.0f : 1.0f;
	
	float shadowCoeff = lerp( lerp( s0, s1, lerps.x ),
                              lerp( s2, s3, lerps.x ),
                              lerps.y );
	
	// Light/Texture pixel.  Note that shadow coefficient only affects diffuse/spec.
	//float3 litColor = spot*ambient*texColor.rgb + spot*shadowCoeff*(diffuse*texColor.rgb + spec);
	float3 litColor = texColor.rgb + spot*shadowCoeff*(diffuse*texColor.rgb + spec);
	
	return float4(litColor, texColor.a);//float4(litColor, g_diffuse_mtrl.a*texColor.a);
}

technique normal
{
	pass p0
	{
		vertexShader = compile vs_3_0 SpecularVS();
		pixelShader = compile ps_3_0 SpecularPS();
	}
}